<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

use yii\helpers\ArrayHelper;
use frontend\models\Ledger;
?>

<h1>Vendor Ledger</h1>

<div>


<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['vendors/vledger'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options'=>['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options'=>['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
    ]
]); ?>

</div>
<div class="well well-sm">

  <?= Html::dropDownList('vendor',null, ArrayHelper::map(Ledger::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['ptype'=>2])->all(),'vendor','label'),['class'=>'form-control','prompt'=>'']) ?>

</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>
<table class="table table-bordered table-striped">
	<tr>
<th>Date</th>
<th>Description</th>
<th>Amount Due</th>
<th>Paid</th>

<th>Balance</th>
	</tr>
    <?php
$van=0;
$van2=0;
if($income!=null){

	foreach($income as $inc){
	?>

<tr>
<td><?= date("jS F Y",strtotime($inc['created_at'])) ?></td>
<td>
<?= Html::a(ucwords($inc['description']),['/ledger/pay','tid'=>$inc['transaction_id'],'tlink'=>$inc['tlink'],'id'=>$inc['id']],['class'=>'btn btn-primary','target'=>'blank']) ?>
</td>
<td><?php $stat+=$inc['debit']; echo $inc['debit']; ?></td>
<td><?php $van+=$inc['amount_paid']; echo $inc['amount_paid']; ?></td>
<td><?php $van2+=$inc['debit']-$inc['amount_paid']; echo $stat-$van; ?></td>


</tr>



	<?php
}
}
    ?>
    <tr>
<th colspan="2"></th>
<th>Total</th>
<th><?= $van ?></th>
<th><?= $van2 ?></th>
    </tr>
    </table>

</div>