<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

?>
<h1>Sales Report</h1>


<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['sales/sales_report'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
    ]
]); ?>

</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>


</div>

<div id="holder">
<?php

if($model!=null)
{
    // var_dump($model);
    echo "<h3>Sales Report for period from ". date('jS F Y',strtotime($from)).' to '.date('jS F Y',strtotime($to))."</h3>";

?>
<table class="table table-bordered table-striped">
<tr style="text-transform:uppercase">
<td>item name</td>
<td>Quantity</td>
<td>price (<del>N</del> )</td>
<td>total (<del>N</del> )</td>
<td>Customer</td>
</tr>
<?php
$tot=0;
foreach($model as $mod)
{

    $load=json_decode($mod['requested_item'],true);
    // var_dump($load[0]);
    foreach($load as $lo)
    {
        $tot+=$lo['total'];
?>

<tr style="">
<td><?= ucwords($lo['item_name']) ?></td>
<td><?= $lo['quantity'] ?></td>
<td><?= number_format($lo['amount'],2) ?></td>
<td><?=  number_format($lo['total'],2) ?></td>
<td><?= ucwords($lo['customer_name']) ?></td>
</tr>

<?php
}
}
?>
<tr style="font-weight:bold; text-transform:uppercase;">
<td></td>
<td></td>
<td >TOTAL sales</td>
<td><del>N</del> <?= number_format($tot,2)  ?></td>
<td></td>
</tr>
<?php
}
?>

</table>
</div>

    <div style="margin-top:20px;">
    
<?= Html::button('Print Document',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?>

    </div>