<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\models\Clients;
use backend\models\Departments;
use backend\models\User;
use backend\models\RequisitionTypes;

/* @var $this yii\web\View */
/* @var $model frontend\models\Requisitions */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Requisitions', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="requisitions-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
           // 'id',
            ['label'=>'Client Name', 'format'=>'raw', 'value'=>ucwords(Clients::find()->where(['id'=>$model->cid])->one()->client_name),[]],
            
            ['label'=>'Originating Department', 'format'=>'raw', 'value'=>ucwords(Departments::find()->where(['id'=>$model->originating_department])->one()->department_name),[]],
            
           // ['label'=>'Raise By', 'format'=>'raw', 'value'=>ucwords(User::raised_by($model->raised_by)),[]],
            // ['label'=>'Requisitions Type', 'format'=>'raw', 'value'=>ucwords(RequisitionTypes::find()->where(['id'=>$model->requisition_type])->one()->requisition_type),[]],
            //'workflow_id',
         //   'requested_item:ntext',
           // 'quantity',
           // ['label'=>'Amount','format'=>'raw','value'=>number_format($model->amount,2)],           
          //  ['label'=>'Total','format'=>'raw','value'=>number_format($model->total,2)],
          //  ['label'=>'To be used by','format'=>'raw','value'=>ucfirst($model->to_be_used_by)],
            
           // 'status',
           // 'created_at',
           // 'updated_at',
        ],
    ]) ?>

</div>
