<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
?>
<h1>Profit and Loss</h1>


<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['requisitions/pnl'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
    ]
]); ?>

</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>

<div>
	<table class="table table-bordered table-striped">
		<tr>
<td colspan="2" style="text-transform:uppercase; font-size:26px; font-weight:bold;">Income</td>
		</tr>

	
<?php
if($income!=null){
foreach($income as $inc)
{
	?>
	<tr>
<td><?= $inc['title'] ?></td>
<td><del>N</del> <?= number_format($total_income,2) ?></td>

	</tr>

	<?php
}
}
?>


	<tr>
<td colspan="2" style="text-transform:uppercase; font-size:26px; font-weight:bold;">Expenditure</td>
		</tr>

	
<?php
if($expenditure!=null){
foreach($expenditure as $exp)
{
	?>
	<tr>
<td><?= 'Expenses' ?></td>
<td><del>N</del> <?= number_format($total_exp,2) ?></td>

	</tr>

	<?php
}}
?>

<tr>
<?php if($total_income>$total_exp){ ?>
<td style="text-transform:uppercase; font-size:26px; font-weight:bold;">Total net Profit</td>
<td style="text-transform:uppercase; font-size:18px; font-weight:bold;"><del>N</del> <?= number_format($total_income-$total_exp,2) ?></td>
<?php } ?>

<?php if($total_exp>$total_income){ ?>
<td style="text-transform:uppercase; font-size:26px; font-weight:bold;">Total Loss</td>
<td style="text-transform:uppercase; font-size:18px; font-weight:bold;"><del>N</del> <?= number_format($total_exp-$total_income,2) ?></td>
<?php } ?>
</tr>
</table>
</div>

</div>