<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\models\Banks;
use yii\helpers\ArrayHelper;
use frontend\models\Customers;
use frontend\models\Vendors;
use frontend\models\Requisitions;
?>
<?php
$this->title = 'Ledgers';
$this->params['breadcrumbs'][] = $this->title;

?>

<h1>Reverse Transaction</h1>

<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['ledger/reverse'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,

    ]
]); ?>

</div>

<div class="well well-sm">
 <?= Html::textInput('tid',null,['class'=>'form-control','placeholder'=>'Enter Transaction ID','id'=>'tid','autocomplete'=>'off']) ?>
</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>


<div>

<table class="table table-striped table-bordered">
<tr>
	<th>Transaction ID</th>
    <th>Narration</th>
<th>Vendor</th>
<th>Amount Due</th>
<th>Amount Paid</th>
<th>Transaction Type</th>
<th>Balance</th>
<th></th>
</tr>

<?php
if($reverse!=null){
foreach($reverse as $rev)
{ 
	$querya="select sum(amount_paid) from ledger where tlink='".$rev['transaction_id']."'";
	$saj = Yii::$app->db->createCommand($querya)->queryScalar(); 

    $nar=Requisitions::find()->where(['transaction_id'=>$rev['transaction_id']])->one();

    $item7=json_decode($nar['requested_item'],true);
   
	?>
<tr>
<td><?= $rev['transaction_id'] ?></td>
<td><?= !empty($item7[0]['narration']) ? ucfirst($item7[0]['narration']) : 'Not Set' ?></td>
<td><?= $rev['ptype']==1 ? ucwords(Customers::findOne($rev['vendor'])->name) : ucwords(Vendors::findOne($rev['vendor'])->name) ?></td>
<td><?= $rev['ptype']==1 ? $rev['credit'] : $rev['debit'] ?></td>
<td><?= $rev['amount_paid']+$saj ?></td>
<td><?= $rev['ptype']==1 ? 'Sales Transaction' : 'Expenditure Transaction' ?></td>
<td><?= $rev['ptype']==1 ? $rev['credit']-$rev['amount_paid']-$saj : $rev['debit']-$rev['amount_paid']-$saj ?></td>
<td><?= Html::a('Reverse',['/ledger/reverseit','tid'=>$rev['transaction_id'],'id'=>$rev->id],['class'=>'btn btn-danger','onclick'=>'return confirm("Do you want to Reverse this?")']) ?></td>
</tr>
	<?php
}		
}
?>


</table>
</div>